TITLE   'Electrical Conduction in a Cone, Fe and Cu'                            { exa354b.pde }
SELECT     errlim=1e-3  spectral_colors		
COORDINATES     cartesian3
VARIABLES   U
DEFINITIONS
   r0=2e-3     r1=10e-3     h=10e-3     cond   		{ Silicon }
   Ex=-dx( U)     Ey=-dy( U)     Ez=-dz( U)
   E=-grad( U)     Em=magnitude( E)
   Jx=cond*Ex     Jy=cond*Ey     Jz=cond*Ez
   J=cond*E     Jm=magnitude( J)
   rad=sqrt( x^2+ y^2)					{ Radius }
   power=vol_integral( Jm*Em)			{ Dissipation }
   current=surf_integral( normal( J),'top')	
EQUATIONS
   div( J)=0
EXTRUSION
   surface 'lower' z=max( 0, h*(rad-r0)/(r1-r0))	{ Flat base plus cone }
   surface 'top' z=h					{ Flat upper surface }
BOUNDARIES
   surface 'top' value( U)=1.0				{ 1 volt applied on top }
region 'conical ring'	cond=5.0			{ Total region minus cylinder }
   surface 'lower' natural( U)=0			{ dU/dn=0 on cone }
   start (r1, 0)   arc( center=0,0) angle=360 to finish
region 'cylinder'  cond=1.0						{ Overwrites total }
   surface 'lower' value( U)=0				{ Lower flat face }	
   start (r0, 0)   arc( center=0,0) angle=360 to finish
PLOTS
   grid( x,y,z) report(power) report(current)
   contour( U) on x=0     vector( J) norm on x=0
   elevation( tangential( E))
       line_integrate from (0,r1/2,h) to (0,0,0)	{ Voltage }
   contour( Jm) painted on x=0
END
